<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */
?>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div id="message_info" class="message">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					<script>
						$(function() {
							$("#tabs").tabs();
							$('[id^=public-modal]').dialog({ autoOpen: false })
							$('[id^=public-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('public-link','');
								$('[id^=public-modal]').dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id=public-modal'+id+']').dialog('open');
							});
							$('[id^=private-modal]').dialog({ autoOpen: false })
							$('[id^=private-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('private-link','');
								$( "[id^=private-modal]" ).dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id^=private-modal'+id+']').dialog('open');
							});
						});
					</script>
					
					<?PHP
						echo form_open('/administration/manage/facilities',array('id'=>'app_list_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'active_page_on_bar' => '',
							'active_page_select' => '',
							'active_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'inactive_page_on_bar' => '',
							'inactive_page_select' => '',
							'inactive_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div id="tabs" class="column">
						<ul>
							<li><a id="active_link" href="#active" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Facilities</a></li>
							<li><a id="create_link" href="#create" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Create Facility</a></li>
						</ul>
						<div id="active">
							<p>This table lists the existing facilities.</p>
							
							<?php if (sizeof($facility_list) == 0) { ?>
								<div class="message">You currently have no active facilities.</div>
							<?php }else{ ?>
								<?PHP echo form_open('/administration/manage/facilities',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($active_size)) { echo $active_size; } else {echo "0";}?> result<?php if(isset($active_size) && $active_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_pagination_bar)) { echo $active_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_items_per_page_dropdown)) { echo $active_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="active_page_select" name="active_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $active_items_per_page;?>, 'active_');" >
												<?php for($count = 1;$count <= $active_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $active_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $active_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
								<table class="display">
									<tr>
										<th width="75%">Name</th>
										<th width="15%">Active</th>
										<th width="10%" class="displaylast">Action</th>
									</tr>
									<?php $count = 0; foreach($facility_list as $fac){ ?>
										<tr>
											<td>
												<a href="/administration/manage/facilities/edit/<?php echo $fac->id; ?>/<?php if($active_cur_page){echo $active_cur_page;}else{echo 1;} ?>/<?php if($active_items_per_page){echo $active_items_per_page;}else{echo $ITEMS_PER_PAGE_DEFAULT;}?>"><?php echo $fac->name; ?></a>&nbsp;
											</td>
											
											<td class="center">
												<?php if($fac->active) {?>Yes<?php } else {?>No<?php }?>
											</td>
											<td>
												<!-- form is actually submitted via ajax and is controlled in main.js -->
												<?PHP echo form_open('/facilities/update_key',array('id'=>'keyForm'.$fac->id,'class'=>'keyForm')); ?>
													<?PHP echo form_hidden('app_id',$fac->id,'app_id'); ?>
													<div class="center">
														<a href="/administration/manage/facilities/edit/<?php echo $fac->id; ?>/<?php if($active_cur_page){echo $active_cur_page;}else{echo 1;} ?>/<?php if($active_items_per_page){echo $active_items_per_page;}else{echo $ITEMS_PER_PAGE_DEFAULT;}?>" title="Edit Facility: <?php echo $fac->name; ?>"><img src="/images/icons/application_edit.png" alt="Edit Facility: <?php echo $fac->name; ?>" /></a>
													</div>
												<?PHP echo form_close(); ?>
											</td>
										</tr>
									<?php $count++; } ?>
								</table>
								<?PHP echo form_open('/administration/manage/facilities',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($active_size)) { echo $active_size; } else {echo "0";}?> result<?php if(isset($active_size) && $active_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_pagination_bar)) { echo $active_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_items_per_page_dropdown)) { echo $active_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="active_page_select" name="active_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $active_items_per_page;?>, 'active_');" >
												<?php for($count = 1;$count <= $active_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $active_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $active_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
							<?php } ?>
						</div>
						<div id ="create" class="column">		
							<p>This form allows an administrator to create a facility.</p>
							<?PHP echo form_open('/administration/facility_create',array('id'=>'createFacilityForm')); ?>
								<div class="form" style="width:100%;">
									<label for="fac_name">Facility Name:</label> 
									<p class="hidden_context">Help Text for Facility Name: Please enter the name of the facility.</p>
									<input class="ttFocus" title="Please enter the name of the facility." type="text" name="fac_name" id="fac_name" <?PHP if(isset($fac_name)) { echo 'value="'.$fac_name.'"'; }?>/>
									
									<label for="admin_api_permission" style="width: 180px;">Active:</label>
									<p class="hidden_context">Help Text for Facility active attribure: Please determine the facility is active.</p> 
									<input class="ttHover" title="Please determine if the facility is active." type="checkbox" name="is_active" id="is_active" <?php if(isset($is_active) && $is_active){?> checked <?php }?>/>&nbsp;&nbsp;
								</div>
								<div class="text-right" style="width:100%;"><input class="blue-button" type="submit" value="Submit"/></div> 
							<?PHP echo form_close(); ?>
						</div>	
					</div>
				</div>
			</div>
		</div>
	</body>
</html>

<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo get_instance()->json->encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo get_instance()->json->encode($form_values); ?>);
</script>